---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-フォームレイアウト（Bootstrap 5）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  - なし（全主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_5_layout.html.twig` L1-371
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` L1-209
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行50（No.49のエントリ）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行124-125（No.49の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bootstrap_base_layoutをuseタグで読み込む | E-01 L1 | ○ |
| C-02 | money_widgetでinput-group-text直接使用（prepend/appendなし） | E-01 L5-21 | ○ |
| C-03 | date_widgetでvisually-hidden + input-group構造 | E-01 L23-52 | ○ |
| C-04 | time_widgetでvisually-hidden + input-group構造 | E-01 L54-91 | ○ |
| C-05 | datetime_widgetでis-invalidバリデーション対応 | E-01 L93-108 | ○ |
| C-06 | dateinterval_widgetでcol-auto mb-3構造 | E-01 L110-164 | ○ |
| C-07 | form_widget_simpleでform-control/form-control-color/form-rangeの振り分け | E-01 L177-192 | ○ |
| C-08 | widget_attributesでis-invalidクラス条件付き適用 | E-01 L194-199 | ○ |
| C-09 | button_widgetでbtn-secondary btn適用 | E-01 L201-204 | ○ |
| C-10 | submit_widgetでbtn-primary適用 | E-01 L206-209 | ○ |
| C-11 | checkbox_widgetでform-check/form-switch/btn-check対応 | E-01 L211-233 | ○ |
| C-12 | radio_widgetでform-check/btn-check対応 | E-01 L235-254 | ○ |
| C-13 | choice_widget_collapsedでform-selectクラス適用 | E-01 L256-259 | ○ |
| C-14 | form_labelでform-label/col-form-label/input-group-text振り分け | E-01 L275-292 | ○ |
| C-15 | form_row_renderでmb-3/form-floating/input-group対応 | E-01 L323-339 | ○ |
| C-16 | form-floatingでwidgetとlabelの順序入れ替え | E-01 L329-331 | ○ |
| C-17 | form_errorsで各エラー独立div表示 | E-01 L349-355 | ○ |
| C-18 | form_helpでform-text mb-0/input-group-text切り替え | E-01 L359-370 | ○ |
| C-19 | 関連機能：Form、Twig Bridge | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートファイルの全ブロックを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Bootstrap 5固有のCSSクラス名が正確か確認（特にform-select、visually-hidden、form-range）
- [ ] form-floating対応のwidget/label順序入れ替えロジックが正確か確認
- [ ] input-group対応のラベル/ヘルプクラス切り替えが正確か確認
- [ ] Bootstrap 4からの変更点リストが網羅的か確認
